<?php
// admin/bookings.php
include '../../config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$sql = "
  SELECT 
    b.id,
    b.user_id,
    u.first_name,
    u.last_name,
    u.phone,
    b.service_type,
    b.price_ids,
    b.date,
    b.time,
    b.frequency,
    b.address,
    b.instructions,
    b.eco_friendly,
    b.total_price,
    b.status,
    b.created_at
  FROM bookings b
  JOIN users u ON b.user_id = u.id
  ORDER BY b.created_at DESC
";

$res = mysqli_query($conn, $sql);
if (!$res) {
    echo json_encode(['status' => 'error', 'message' => 'DB query failed']);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
    $ids = array_filter(array_map('intval', explode(',', $row['price_ids'])));
    $prices = [];

    if (count($ids) > 0) {
        $in = implode(',', $ids);
        $r2 = mysqli_query($conn, "SELECT id, name, price FROM service_prices WHERE id IN ($in)");
        while ($p = mysqli_fetch_assoc($r2)) {
            $prices[] = $p;
        }
    }

    $row['prices'] = $prices;
    $row['user_name'] = $row['first_name'] . ' ' . $row['last_name'];
    unset($row['first_name'], $row['last_name']);

    $data[] = $row;
}

echo json_encode(['status' => 'success', 'data' => $data]);
?>
