<?php
include '../../config.php';

$response = [];

date_default_timezone_set('Africa/Nairobi');
$today = date('Y-m-d');
$monthStart = date('Y-m-01');

// Customers
$userQuery = mysqli_query($conn, "SELECT COUNT(*) AS total FROM users WHERE type = 0");
$todayUserQuery = mysqli_query($conn, "SELECT COUNT(*) AS today FROM users WHERE type = 0 AND DATE(created_at) = '$today'");
$monthlyUserQuery = mysqli_query($conn, "SELECT COUNT(*) AS monthly FROM users WHERE type = 0 AND DATE(created_at) >= '$monthStart'");

// Bookings
$bookingQuery = mysqli_query($conn, "SELECT COUNT(*) AS total FROM bookings");
$pendingQuery = mysqli_query($conn, "SELECT COUNT(*) AS pending FROM bookings WHERE status = 0");
$approvedQuery = mysqli_query($conn, "SELECT COUNT(*) AS approved FROM bookings WHERE status = 1");
$canceledQuery = mysqli_query($conn, "SELECT COUNT(*) AS canceled FROM bookings WHERE status = 2");
$todayBookingQuery = mysqli_query($conn, "SELECT COUNT(*) AS today FROM bookings WHERE DATE(created_at) = '$today'");
$monthlyBookingQuery = mysqli_query($conn, "SELECT COUNT(*) AS monthly FROM bookings WHERE DATE(created_at) >= '$monthStart'");

// Donations
$donationQuery = mysqli_query($conn, "SELECT COUNT(*) AS total FROM donations");
$todayDonationQuery = mysqli_query($conn, "SELECT COUNT(*) AS today FROM donations WHERE DATE(created_at) = '$today'");
$monthlyDonationQuery = mysqli_query($conn, "SELECT COUNT(*) AS monthly FROM donations WHERE DATE(created_at) >= '$monthStart'");

$response['total_users'] = mysqli_fetch_assoc($userQuery)['total'];
$response['today_users'] = mysqli_fetch_assoc($todayUserQuery)['today'];
$response['monthly_users'] = mysqli_fetch_assoc($monthlyUserQuery)['monthly'];

$response['total_bookings'] = mysqli_fetch_assoc($bookingQuery)['total'];
$response['pending_bookings'] = mysqli_fetch_assoc($pendingQuery)['pending'];
$response['approved_bookings'] = mysqli_fetch_assoc($approvedQuery)['approved'];
$response['canceled_bookings'] = mysqli_fetch_assoc($canceledQuery)['canceled'];
$response['today_bookings'] = mysqli_fetch_assoc($todayBookingQuery)['today'];
$response['monthly_bookings'] = mysqli_fetch_assoc($monthlyBookingQuery)['monthly'];

$response['total_donations'] = mysqli_fetch_assoc($donationQuery)['total'];
$response['today_donations'] = mysqli_fetch_assoc($todayDonationQuery)['today'];
$response['monthly_donations'] = mysqli_fetch_assoc($monthlyDonationQuery)['monthly'];

echo json_encode([
    'status' => 'success',
    'data' => $response
]);
