<?php
// donations.php
include '../../config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status'=>'error','message'=>'Invalid request']);
    exit;
}

$sql = "
  SELECT 
    d.id,
    d.user_id,
    u.first_name,
    u.last_name,
    u.phone,
    d.category,
    d.quantity,
    d.area,
    d.created_at
  FROM donations d
  JOIN users u ON u.id = d.user_id
  ORDER BY d.created_at DESC
";
$res = mysqli_query($conn, $sql);
if (!$res) {
    echo json_encode(['status'=>'error','message'=>'DB query failed']);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
    $data[] = [
      'id'         => $row['id'],
      'user_id'    => $row['user_id'],
      'user_name'  => $row['first_name'] . ' ' . $row['last_name'],
      'phone'      => $row['phone'],
      'category'   => $row['category'],
      'quantity'   => (int)$row['quantity'],
      'area'       => $row['area'],
      'created_at' => $row['created_at'],
    ];
}

echo json_encode(['status'=>'success','data'=>$data]);
?>
