<?php
include '../../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? null;
    $price = $_POST['price'] ?? null;

    if (!$id || !$price) {
        echo json_encode(['success' => false, 'message' => 'Missing fields']);
        exit;
    }

    $query = "UPDATE service_prices SET price = ? WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "ii", $price, $id);
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode(['success' => true, 'message' => 'Price updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update price']);
        }
        mysqli_stmt_close($stmt);
    } else {
        echo json_encode(['success' => false, 'message' => 'Query error']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>
