<?php
// book_service.php
include '../config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request method']);
    exit;
}

// Required fields
$required = ['user_id','service_type','price_ids','date','time','frequency','address','eco_friendly'];
foreach ($required as $f) {
    if (empty($_POST[$f]) && $_POST[$f] !== '0') {
        echo json_encode(['status'=>'error','message'=>"Missing field: $f"]);
        exit;
    }
}

$user_id      = (int) $_POST['user_id'];
$service_type = mysqli_real_escape_string($conn, $_POST['service_type']);
$price_ids    = $_POST['price_ids'];            // e.g. "1,2,3"
$date         = $_POST['date'];                 // YYYY-MM-DD
$time         = $_POST['time'];                 // HH:MM or HH:MM:SS
$frequency    = mysqli_real_escape_string($conn, $_POST['frequency']);
$address      = mysqli_real_escape_string($conn, $_POST['address']);
$instructions = mysqli_real_escape_string($conn, $_POST['instructions'] ?? '');
$eco_friendly = (int) $_POST['eco_friendly'];    // 0 or 1

// Validate frequency
$allowed = ['onetime','daily','weekly','monthly'];
if (!in_array($frequency, $allowed, true)) {
    echo json_encode(['status'=>'error','message'=>'Invalid frequency']);
    exit;
}

// Compute total_price by summing the service_prices table
$ids_array = array_filter(array_map('intval', explode(',', $price_ids)));
if (empty($ids_array)) {
    echo json_encode(['status'=>'error','message'=>'No valid price IDs']);
    exit;
}
$in_list = implode(',', $ids_array);

$sql_sum = "SELECT SUM(price) AS total FROM service_prices WHERE id IN ($in_list)";
$res_sum = mysqli_query($conn, $sql_sum);
if (!$res_sum) {
    echo json_encode(['status'=>'error','message'=>'Error calculating total price']);
    exit;
}
$row = mysqli_fetch_assoc($res_sum);
$total_price = $row['total'] ?? 0.00;

// Finally insert booking
$stmt = mysqli_prepare($conn, "
    INSERT INTO bookings
      (user_id, service_type, price_ids, date, time, frequency, address, instructions, eco_friendly, total_price)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    echo json_encode(['status'=>'error','message'=>'Prepare failed']);
    exit;
}

mysqli_stmt_bind_param(
    $stmt,
    'isssssssid',
    $user_id,
    $service_type,
    $price_ids,
    $date,
    $time,
    $frequency,
    $address,
    $instructions,
    $eco_friendly,
    $total_price
);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['status'=>'success','message'=>'Booking confirmed']);
} else {
    echo json_encode(['status'=>'error','message'=>'Failed to create booking']);
}

mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
