<?php
// donate.php
include '../config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request']);
    exit;
}

// Required fields
$user_id  = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
$category = trim($_POST['category']  ?? '');
$quantity = isset($_POST['quantity']) ? (int)$_POST['quantity'] : 0;
$area     = trim($_POST['area']      ?? '');

if ($user_id <= 0 || $category === '' || $quantity <= 0 || $area === '') {
    echo json_encode(['status'=>'error','message'=>'Missing or invalid fields']);
    exit;
}

// Insert donation
$stmt = mysqli_prepare($conn, "
  INSERT INTO donations (user_id, category, quantity, area)
  VALUES (?, ?, ?, ?)
");
mysqli_stmt_bind_param($stmt, 'isis', $user_id, $category, $quantity, $area);
if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['status'=>'success','message'=>'Thank you for your donation!']);
} else {
    echo json_encode(['status'=>'error','message'=>'Failed to record donation']);
}
mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
