<?php
// my_booking.php
include '../config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
if ($user_id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid user_id']);
    exit;
}

$sql = "
  SELECT 
    b.id,
    b.service_type,
    b.price_ids,
    b.date,
    b.time,
    b.frequency,
    b.address,
    b.instructions,
    b.eco_friendly,
    b.total_price,
    b.status,
    b.created_at
  FROM bookings b
  WHERE b.user_id = $user_id
  ORDER BY b.created_at DESC
";
$res = mysqli_query($conn, $sql);
if (!$res) {
    echo json_encode(['status' => 'error', 'message' => 'DB query failed']);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
    // Parse price_ids into an array of ints
    $ids = array_filter(array_map('intval', explode(',', $row['price_ids'])));
    if (count($ids) > 0) {
        $in = implode(',', $ids);
        $q2 = "SELECT id, name, price FROM service_prices WHERE id IN ($in)";
        $r2 = mysqli_query($conn, $q2);
        $prices = [];
        while ($p = mysqli_fetch_assoc($r2)) {
            $prices[] = $p;
        }
    } else {
        $prices = [];
    }
    // Attach the detailed prices array
    $row['prices'] = $prices;

    $data[] = $row;
}

echo json_encode(['status' => 'success', 'data' => $data]);
?>
