<?php
include '../../config.php';

// 1) Use Dar es Salaam time everywhere
date_default_timezone_set('Africa/Dar_es_Salaam');

// Read raw POST from Selcom
$body = file_get_contents("php://input");
$data = json_decode($body, true);
error_log("Selcom webhook payload: " . print_r($data, true));

// Validate required fields
if (!isset(
    $data['transid'],
    $data['order_id'],
    $data['reference'],
    $data['result'],
    $data['resultcode'],
    $data['payment_status']
)) {
    echo json_encode(['status'=>'error','message'=>'Missing required parameters']);
    exit;
}

// Map incoming values
$transId       = $data['transid'];
$orderId       = $data['order_id'];
$reference     = $data['reference'];
$result        = $data['result'];
$resultcode    = $data['resultcode'];
$paymentStatus = $data['payment_status'];
$tid           = isset($_GET['tid']) ? $_GET['tid'] : null;
$now = date('Y-m-d H:i:s');

// 2) Log into transactions_logs (you can add a `logged_at` DATETIME column default NOW() if you like)
$stmt = $conn->prepare(
    "INSERT INTO transactions_logs
     (transid, order_id, reference, result, resultcode, payment_status, tid, created_at)
     VALUES (?, ?, ?, ?, ?, ?, ?, ?)"
);
$stmt->bind_param("ssssssss",
    $transId, $orderId, $reference,
    $result, $resultcode, $paymentStatus,
    $tid, $now
);
$stmt->execute();

// Only handle completed payments
if ($paymentStatus === 'COMPLETED') {
    // 3) Fetch pending transaction
    $q = $conn->prepare(
        "SELECT book_id, amount, user_id
         FROM pending_transactions
         WHERE tid = ?"
    );
    $q->bind_param("s", $tid);
    $q->execute();
    $tx = $q->get_result()->fetch_assoc();

    if (!$tx) {
        error_log("No pending transaction for TID {$tid}");
        echo json_encode(['status'=>'error','message'=>'Pending transaction not found']);
        exit;
    }

    // 4) Insert into purchased_books with text status and timestamp
    $now = date('Y-m-d H:i:s');
    $ins = $conn->prepare(
        "INSERT INTO purchased_books
         (book_id, description, user_id, status, tid, purchase_date)
         VALUES (?, ?, ?, ?, ?, ?)"
    );
    $desc   = 'Manunuzi ya kitabu';
    $status = 'Paid';
    $ins->bind_param(
        "isssss",
        $tx['book_id'],
        $desc,
        $tx['user_id'],
        $status,
        $tid,
        $now
    );

    if (!$ins->execute()) {
        error_log("Failed to insert repayment: " . $conn->error);
        echo json_encode(['status'=>'error','message'=>'Failed to record repayment']);
        exit;
    }

    echo json_encode([
        'status'=>'success',
        'message'=>'Payment saved and Book Purchased'
    ]);
} else {
    // Not completed → nothing else to do
    echo json_encode(['status'=>'info','message'=>'Payment not completed']);
}
