<?php
// Include the database connection file
include '../config.php';

// Set the response header to JSON
header('Content-Type: application/json');

// Check if the user_id is provided
if (isset($_GET['user_id'])) {
    $user_id = $_GET['user_id'];

    // Prepare the SQL query to get the profile data
    $query = "SELECT `id`, `first_name`, `last_name`, `phone`, `email` FROM `users` WHERE `id` = ?";
    
    // Initialize the statement
    $stmt = $conn->prepare($query);
    
    // Bind the user_id parameter
    $stmt->bind_param('i', $user_id); // 'i' means integer
    
    // Execute the query
    $stmt->execute();
    
    // Get the result
    $result = $stmt->get_result();

    // Check if the user exists
    if ($result->num_rows > 0) {
        // Fetch the user data
        $user = $result->fetch_assoc();

        // Prepare the response data
        $response = array(
            'status' => 'success',
            'profile' => $user
        );
    } else {
        // No user found
        $response = array(
            'status' => 'error',
            'message' => 'User not found'
        );
    }
} else {
    // User ID not provided
    $response = array(
        'status' => 'error',
        'message' => 'User ID is required'
    );
}

// Return the response in JSON format
echo json_encode($response);

// Close the statement and connection
$stmt->close();
$conn->close();
?>
